//
//  QuicksilverPlugin.h
//  AdiumQuicksilverPlugin
//
//  Created by Brian Donovan on 08/02/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <Foundation/NSConnection.h>
#import <Adium/AIPlugin.h>
#import <Adium/AIAdiumProtocol.h>
#import <Adium/AIListContact.h>
#import <Adium/AIContentMessage.h>
#import <Adium/AIMetaContact.h>

#define foreach(x,y) id x;NSEnumerator *rwEnum=[y objectEnumerator];while(x=[rwEnum nextObject])

@class AIListContact, AIListGroup, AIChat;
@protocol AIAdium;

@protocol AdiumQuicksilverPlugin;

@interface QuicksilverPlugin : AIPlugin <AdiumQuicksilverPlugin> {
	NSConnection *conn;
}

@end

@protocol AdiumQuicksilverPlugin
/* retrieving information */
- (id<AIAdium>)adium;
- (NSArray *)contacts;
- (NSArray *)groups;
- (NSArray *)groupsRestrictingToVisible:(BOOL)visible;
- (NSArray *)chats;
- (AIListContact *)contactWithServiceID:(NSString *)serviceID UID:(NSString *)username forSendingContentType:(NSString *)type;
- (NSArray *)contactsInGroup:(AIListGroup *)group;
- (NSArray *)contactsWithGroupUID:(NSString *)groupUID;
- (NSArray *)contactsWithGroupUID:(NSString *)groupUID restrictingToVisible:(BOOL)visible;
- (NSArray *)contactsForMetaContactWithID:(NSString *)contactID;
- (AIListGroup *)groupWithUID:(NSString *)groupUID;
- (NSArray *)consolidateContacts:(NSArray *)contacts;
- (NSArray *)consolidatedContactsWithGroupUID:(NSString *)groupUID restrictingToVisible:(BOOL)visible;
- (NSAttributedString *)statusMessageForContactWithServiceID:(NSString *)serviceID UID:(NSString *)username;

/* sending content */
- (void)sendMessage:(NSString *)message toContact:(AIListContact *)contact autoreply:(BOOL)autoreply;
- (int)sendMessage:(NSString *)message toContact:(NSString *)username withServiceID:(NSString *)service autoreply:(BOOL)autoreply laterIfOffline:(BOOL)laterIfOffline;
- (void)sendMessageLater:(NSString *)message toContact:(AIListContact *)contact autoreply:(BOOL)autoreply;

/* opening chats */
- (AIChat *)openChatWithContact:(AIListContact *)contact active:(BOOL)active;
- (AIChat *)openChatWithContact:(NSString *)username withServiceID:(NSString *)serviceID active:(BOOL)active;

/* setting properties */
- (void)setAwayMessage:(NSString *)message;
- (void)setAvailableMessage:(NSString *)message;
@end
